//Create by: Bram van Deventer, 27-08-2013
//
// LCD PINOUT for Glcd_48x100 with a  SED1531 controller
// Pin   LCD                                PIN Arduino
// 
// 1     GND
// 2     +5V                                 
// 3     Backlight (GND)
// 4     AO (L - instruction/ H - data)      Digital 12
// 5     Read/Write (H - Read / L - Writer)  Digital 11
// 6     Enable Digital                      Digital 10
//
// Data
// 7    DB 7 MSB          Digital 9
// 8    DB 6              Digital 8
// 9    DB 5              Digital 7
// 10   DB 4              Digital 6
// 11   DB 3              Digital 5
// 12   DB 2              Digital 4
// 13   DB 1              Digital 3
// 14   DB 0 LSB          Digital 13 //This because PIN2 is a trigger pin (Interrupt)



#include <Adafruit_GPS.h> //Using AdaFruit GPS lib
#include <SoftwareSerial.h> //Serial com


int BTNpin = 2;  	//Button input
volatile int state = LOW;

int lcdA0 = 12; 	 // AO (L - instruction/ H - data)   
int lcdRW = 11; 	 //Read/Write (H - Read / L - Writer) 
int lcdEnable = 10;  //Enable Digital 




int lcdDataPins[] = {9,8,7,6,5,4,3,13}; //Settting PINS

char str[] = "                 ";       // was 20 char's long, now 17

// (5x7 Font) //Setting fonts, you can change there for bigger chars
byte lcdFonts[][5] = {
  {     0x00 , 0x00 , 0x00 , 0x00 , 0x00                                                                                         }
  , 		
  {     0x00 , 0x00 , 0x5F , 0x00 , 0x00                                                                                         }
  , 
  {     0x00 , 0x07 , 0x00 , 0x07 , 0x00                                                                                         }
  , 
  {     0x14 , 0x7F , 0x14 , 0x7F , 0x14                                                                                         }
  , 
  {     0x24 , 0x2A , 0x7F , 0x2A , 0x12                                                                                         }
  , 
  {     0x23 , 0x13 , 0x08 , 0x64 , 0x62                                                                                         }
  , 
  {     0x36 , 0x49 , 0x55 , 0x22 , 0x50                                                                                         }
  , 
  {     0x00 , 0x05 , 0x03 , 0x00 , 0x00                                                                                         }
  , 
  {     0x00 , 0x1C , 0x22 , 0x41 , 0x00                                                                                         }
  , 
  {     0x00 , 0x41 , 0x22 , 0x1C , 0x00                                                                                         }
  , 
  {     0x08 , 0x2A , 0x1C , 0x2A , 0x08                                                                                         }
  , 
  {     0x08 , 0x08 , 0x3E , 0x08 , 0x08                                                                                         }
  , 
  {     0x00 , 0x50 , 0x30 , 0x00 , 0x00                                                                                         }
  , 
  {     0x08 , 0x08 , 0x08 , 0x08 , 0x08                                                                                         }
  , 
  {     0x00 , 0x60 , 0x60 , 0x00 , 0x00                                                                                         }
  , 
  {     0x20 , 0x10 , 0x08 , 0x04 , 0x02                                                                                         }
  , 
  {     0x3E , 0x51 , 0x49 , 0x45 , 0x3E                                                                                         }
  , 
  {     0x00 , 0x42 , 0x7F , 0x40 , 0x00                                                                                         }
  , 
  {     0x42 , 0x61 , 0x51 , 0x49 , 0x46                                                                                         }
  , 
  {     0x21 , 0x41 , 0x45 , 0x4B , 0x31                                                                                         }
  , 
  {     0x18 , 0x14 , 0x12 , 0x7F , 0x10                                                                                         }
  , 
  {     0x27 , 0x45 , 0x45 , 0x45 , 0x39                                                                                         }
  , 
  {     0x3C , 0x4A , 0x49 , 0x49 , 0x30                                                                                         }
  , 
  {     0x01 , 0x71 , 0x09 , 0x05 , 0x03                                                                                         }
  , 
  {     0x36 , 0x49 , 0x49 , 0x49 , 0x36                                                                                         }
  , 
  {     0x06 , 0x49 , 0x49 , 0x29 , 0x1E                                                                                         }
  , 
  {     0x00 , 0x36 , 0x36 , 0x00 , 0x00                                                                                         }
  , 
  {     0x00 , 0x56 , 0x36 , 0x00 , 0x00                                                                                         }
  , 
  {     0x00 , 0x08 , 0x14 , 0x22 , 0x41                                                                                         }
  , 
  {     0x14 , 0x14 , 0x14 , 0x14 , 0x14                                                                                         }
  , 
  {     0x41 , 0x22 , 0x14 , 0x08 , 0x00                                                                                         }
  , 
  {     0x02 , 0x01 , 0x51 , 0x09 , 0x06                                                                                         }
  , 
  {     0x32 , 0x49 , 0x79 , 0x41 , 0x3E                                                                                         }
  , 
  {     0x7E , 0x11 , 0x11 , 0x11 , 0x7E                                                                                         }
  , 
  {     0x7F , 0x49 , 0x49 , 0x49 , 0x36                                                                                         }
  , 
  {    0x3E , 0x41 , 0x41 , 0x41 , 0x22                                                                                         }
  , 
  {     0x7F , 0x41 , 0x41 , 0x22 , 0x1C                                                                                         }
  , 
  {     0x7F , 0x49 , 0x49 , 0x49 , 0x41                                                                                         }
  , 
  {     0x7F , 0x09 , 0x09 , 0x01 , 0x01                                                                                         }
  , 
  {     0x3E , 0x41 , 0x41 , 0x51 , 0x32                                                                                         }
  , 
  {     0x7F , 0x08 , 0x08 , 0x08 , 0x7F                                                                                         }
  , 
  {     0x00 , 0x41 , 0x7F , 0x41 , 0x00                                                                                         }
  , 
  {     0x20 , 0x40 , 0x41 , 0x3F , 0x01                                                                                         }
  , 
  {     0x7F , 0x08 , 0x14 , 0x22 , 0x41                                                                                         }
  , 
  {     0x7F , 0x40 , 0x40 , 0x40 , 0x40                                                                                         }
  , 
  {     0x7F , 0x02 , 0x04 , 0x02 , 0x7F                                                                                         }
  , 
  {     0x7F , 0x04 , 0x08 , 0x10 , 0x7F                                                                                         }
  , 
  {     0x3E , 0x41 , 0x41 , 0x41 , 0x3E                                                                                         }
  , 
  {     0x7F , 0x09 , 0x09 , 0x09 , 0x06                                                                                         }
  , 
  {     0x3E , 0x41 , 0x51 , 0x21 , 0x5E                                                                                         }
  , 
  {     0x7F , 0x09 , 0x19 , 0x29 , 0x46                                                                                         }
  , 
  {     0x46 , 0x49 , 0x49 , 0x49 , 0x31                                                                                         }
  , 
  {     0x01 , 0x01 , 0x7F , 0x01 , 0x01                                                                                         }
  , 
  {     0x3F , 0x40 , 0x40 , 0x40 , 0x3F                                                                                         }
  , 
  {     0x1F , 0x20 , 0x40 , 0x20 , 0x1F                                                                                         }
  , 
  {     0x7F , 0x20 , 0x18 , 0x20 , 0x7F                                                                                         }
  , 
  {     0x63 , 0x14 , 0x08 , 0x14 , 0x63                                                                                         }
  , 
  {     0x03 , 0x04 , 0x78 , 0x04 , 0x03                                                                                         }
  , 
  {     0x61 , 0x51 , 0x49 , 0x45 , 0x43                                                                                         }
  , 
  {     0x00 , 0x00 , 0x7F , 0x41 , 0x41                                                                                         }
  , 
  {     0x02 , 0x04 , 0x08 , 0x10 , 0x20                                                                                         }
  , 
  {     0x41 , 0x41 , 0x7F , 0x00 , 0x00                                                                                         }
  , 
  {     0x04 , 0x02 , 0x01 , 0x02 , 0x04                                                                                         }
  , 
  {     0x40 , 0x40 , 0x40 , 0x40 , 0x40                                                                                         }
  , 
  {     0x00 , 0x01 , 0x02 , 0x04 , 0x00                                                                                         }
  , 
  {     0x20 , 0x54 , 0x54 , 0x54 , 0x78                                                                                         }
  , 
  {     0x7F , 0x48 , 0x44 , 0x44 , 0x38                                                                                         }
  , 
  {     0x38 , 0x44 , 0x44 , 0x44 , 0x20                                                                                         }
  , 
  {     0x38 , 0x44 , 0x44 , 0x48 , 0x7F                                                                                         }
  , 
  {     0x38 , 0x54 , 0x54 , 0x54 , 0x18                                                                                         }
  , 
  {     0x08 , 0x7E , 0x09 , 0x01 , 0x02                                                                                         }
  , 
  {     0x08 , 0x14 , 0x54 , 0x54 , 0x3C                                                                                         }
  , 
  {     0x7F , 0x08 , 0x04 , 0x04 , 0x78                                                                                         }
  , 
  {     0x00 , 0x44 , 0x7D , 0x40 , 0x00                                                                                         }
  , 
  {     0x20 , 0x40 , 0x44 , 0x3D , 0x00                                                                                         }
  , 
  {     0x00 , 0x7F , 0x10 , 0x28 , 0x44                                                                                         }
  , 
  {     0x00 , 0x41 , 0x7F , 0x40 , 0x00                                                                                         }
  , 
  {     0x7C , 0x04 , 0x18 , 0x04 , 0x78                                                                                         }
  , 
  {     0x7C , 0x08 , 0x04 , 0x04 , 0x78                                                                                         }
  , 
  {     0x38 , 0x44 , 0x44 , 0x44 , 0x38                                                                                         }
  , 
  {     0x7C , 0x14 , 0x14 , 0x14 , 0x08                                                                                         }
  , 
  {     0x08 , 0x14 , 0x14 , 0x18 , 0x7C                                                                                         }
  , 
  {     0x7C , 0x08 , 0x04 , 0x04 , 0x08                                                                                         }
  , 
  {     0x48 , 0x54 , 0x54 , 0x54 , 0x20                                                                                         }
  , 
  {     0x04 , 0x3F , 0x44 , 0x40 , 0x20                                                                                         }
  , 
  {     0x3C , 0x40 , 0x40 , 0x20 , 0x7C                                                                                         }
  , 
  {     0x1C , 0x20 , 0x40 , 0x20 , 0x1C                                                                                         }
  , 
  {     0x3C , 0x40 , 0x30 , 0x40 , 0x3C                                                                                         }
  , 
  {     0x44 , 0x28 , 0x10 , 0x28 , 0x44                                                                                         }
  , 
  {     0x0C , 0x50 , 0x50 , 0x50 , 0x3C                                                                                         }
  , 
  {     0x44 , 0x64 , 0x54 , 0x4C , 0x44                                                                                         }
  , 
  {     0x00 , 0x08 , 0x36 , 0x41 , 0x00                                                                                         }
  , 
  {     0x00 , 0x00 , 0x7F , 0x00 , 0x00                                                                                         }
  , 
  {     0x00 , 0x41 , 0x36 , 0x08 , 0x00                                                                                         }
  , 
  {     0x08 , 0x08 , 0x2A , 0x1C , 0x08                                                                                         }
  , 
  {     0x08 , 0x1C , 0x2A , 0x08 , 0x08                                                                                         }
};



//GPS
SoftwareSerial mySerial(1, 0);   	//RX and TX of GPS
Adafruit_GPS GPS(&mySerial);		//Setting Siral
#define GPSECHO  false				//Define GPSecho, this prints the output to serial. 
boolean usingInterrupt = false;		//Define GPS Interrupt mode 
void useInterrupt(boolean);		    //Define GPS Interrupt mode 

void setup() {

 
  pinMode(BTNpin, OUTPUT);  				//Set Input button
  attachInterrupt(0, btnInput, RISING); 	//Setting function to call on a RISING Interrupt

  //GPS
  GPS.begin(9600);									//Starting GPS at a 9600 buad rate
  GPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA);     //Sending command for RMCGGA output: (recommended minimum) and GGA (fix data)
  GPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ); 		//Sending command for 1Hz update rate
  GPS.sendCommand(PGCMD_ANTENNA);					//Setting External Antanna
  useInterrupt(true);								//Setting useInterrupt true
  delay(1000);										//wait a sec for GPS to setup
  mySerial.println(PMTK_Q_RELEASE);					//?

  pinMode(lcdA0, OUTPUT);							//Setting lcdA0 as output
  pinMode(lcdRW, OUTPUT);							//Setting lcdRW as output
  pinMode(lcdEnable, OUTPUT);						//Setting lcdEnable as output


  for (int i = 0; i <= 7; i++) {					//Setting LCDdataPins as output
    pinMode(lcdDataPins[i], OUTPUT);
  }
  // Define a safe setting of control lines at the very beginning
  digitalWrite(lcdEnable, LOW);
  digitalWrite(lcdRW, HIGH);
  digitalWrite(lcdA0, LOW);


  //digitalWrite(displayPower, HIGH);
  delay(200);                                  
  lcdInit();


  //Set contrast LCD
  writeLCDcontrast(15);
  setLCDcontrast(15);
}



// --------- LOOP ----------
void loop() {
  digitalWrite(BTNpin, state);

  if (! usingInterrupt) {
    char c = GPS.read();			//Read GPS op Char
    if (GPSECHO)
      if (c) Serial.print(c);		
  }

  if (GPS.newNMEAreceived()) {    		// If new Data is received
    if (GPS.parse(GPS.lastNMEA()))   	// Parse the data
      return;
  }


  if(GPS.fix) //If there is a GPS FIX
  {
    setRow(1);   				//Setting row 1
    lcdChar("Fix          ");	//Setting text to row

    setRow(5);												//Setting row 5
    lcdChar(String(GPS.latitude, 4) +','+String(GPS.lat));  //Setting GPS latitude as text of 4 chars to row

    setRow(6);												//Setting row 6
    lcdChar(String(GPS.longitude, 4) +','+String(GPS.lon)); //Setting GPS longitude as text of 4 chars to row
  }
  else
  {
    setRow(1);   				//Setting row 1
    lcdChar("Wacht op GPS");	//Setting text to row
  }

  setRow(2); 	//Setting row 2
  lcdChar("Time  " + String(GPS.hour) + ':' + String(GPS.minute) + ':' + String(GPS.seconds));  //Show Time on Row

  setRow(3); 	//Setting row 3
  lcdChar("Sats: " + String((int)GPS.satellites)); //Show satellites count

  setRow(4);	//Setting row 4
  lcdChar("Speed: " + String((int)GPS.speed*1.85)); //Show GPS Speed




  delay(500);  	 			//Wait
  setRow(1);     			//set row to 1
  lcdChar("           "); 	//set text to row
  delay(500);				//Wait
}




// ------------------------------------ rest of the code - (Ript from Libs-------------------------------

// ---------------- GLCD settings, ignore if you have other LCD ---------------------
void setLCDcontrast(byte constrast) {
  writeCMDdisplay(0x80 + constrast);
}
void writeLCDcontrast(int contrast) {
  sprintf(str,"-> Contrast: %d  ",contrast);
  lcdChar(str);
}

/*
  LCD init commands
 */
void lcdInit() {

  //the following actions are performed to init the lcd
  writeCMDdisplay(0xe2);                                //reset display by software command; the SED1531 is very fast in performing this
  delayMicroseconds(10);                                // so the 10 us is enough
  writeCMDdisplay(0xa1);                                //ADC reverse -- to prevent a mirrorred display
  writeCMDdisplay(0xa2);                                //lcd bias 1/8
  //  writeCMDdisplay(0x2c);                                //power
  //  writeCMDdisplay(0x2e);                                //power
  writeCMDdisplay(0x2f);                                //power
  writeCMDdisplay(0xa6);                                //normal / reverse
  writeCMDdisplay(0x8f);                                //set electronic control
  writeCMDdisplay(0xa4);                                //display off
  writeCMDdisplay(0xaf);                                //display on
  writeCMDdisplay(0x40);                                //sel dram line 1 for com1

}



/*  Control de markers boven in het display
 MARKER 1  20  -- pijltjes boven elkaar
 MARKER 2  31  -- 2 horiz. streepjes van barcode
 MARKER 3  32  -- barcode
 MARKER 4  57  -- batterij
 MARKER 5  69  -- sterretje
 MARKER 6  78  -- pijltje UP
 */
void setMarker(byte marker, boolean on) {


  byte highNibble, lowNibble;
  byte markerLCD;

  switch (marker) {
  case 1 : 
    markerLCD = 20;
    break;
  case 2 : 
    markerLCD = 31;
    break;
  case 3: 
    markerLCD = 32;
    break;
  case 4: 
    markerLCD = 57;
    break;
  case 5: 
    markerLCD = 69;
    break;
  case 6: 
    markerLCD = 78;
    break;
  }

  lowNibble = markerLCD & 0xF;    // Mask out upper nibble
  highNibble = markerLCD;        
  highNibble = highNibble >> 4;         // Shift upper 4 bits to lower
  bitSet(highNibble, 4);          // Set 5th bit high

  writeCMDdisplay(0xb6);          //Set page Address
  writeCMDdisplay(highNibble);     //Set column Address high nibble
  writeCMDdisplay(lowNibble);      //Set column Address low nibble

    writeDATAdisplay(on);
}

/*
  Put COMMAND to display (for configuration purpose)
 */
void writeCMDdisplay(byte cmd) {
  digitalWrite(lcdA0, LOW);
  digitalWrite(lcdRW, LOW);

  byte data = cmd;

  for (int i = 7; i >= 0; i--) {
    int value = data & 0x1;
    digitalWrite(lcdDataPins[i], value);
    data = data >> 1;
  }

  // This is the proper way to handle Enable  
  digitalWrite(lcdEnable, HIGH);
  delayMicroseconds(1);
  digitalWrite(lcdEnable, LOW);

}

/*
  Put DATA to display (pixel data)
 */
void writeDATAdisplay(byte lcdData) {
  digitalWrite(lcdA0, HIGH);
  digitalWrite(lcdRW, LOW);

  byte data = lcdData;

  for (int i = 7; i >= 0 ; i--) {
    int value = data & 0x1;
    digitalWrite(lcdDataPins[i], value);
    data = data >> 1;
  }
  digitalWrite(lcdEnable, HIGH);
  delayMicroseconds(1);
  digitalWrite(lcdEnable, LOW);

}


void invertDisplay(boolean reverse) {
  writeCMDdisplay(0xA6 + (reverse ? 0:1));
}



/*
 Select the row where to write the text
 
 row value between 1 and 6
 */
void setRow(byte row) {
  byte page = 0xB0 + (row - 1);

  writeCMDdisplay(page);
  writeCMDdisplay(0x10);  // This was 0x08 in the original SW, but my interpretation of the datasheet is 0x10
  writeCMDdisplay(0x00);

  lcdChar("                    ");   //Make page empty

  writeCMDdisplay(page);
  writeCMDdisplay(0x10);  // This was 0x08 in the original SW, but my interpretation of the datasheet is 0x10
  writeCMDdisplay(0x00);
}


/*
  Send text string to display
 */
void lcdChar(String text) {
  int charCount = text.length();

  //There is only room for 16+a_few_pixels characters
  if (charCount > 17) {
    charCount = 17;      
  }

  //Start Read-Modify-Write
  writeCMDdisplay(0xE0);

  //Loop trough text
  for (int i = 0; i < charCount; i++) {
    char currentChar = text.charAt(i);

    // Character table starts at Ascii-32, so deduct 32 to get it even with the ascii table
    int lcdCharPosition = currentChar - 32;

    for (int j = 0; j < 5; j++) {
      writeDATAdisplay(lcdFonts[lcdCharPosition][j]);

    }
    writeDATAdisplay(0); //empty column to separate characters
  }

  //End Read-Modify-Write
  writeCMDdisplay(0xEE);

  resetColumnAdress();

}

/*
 Reset column address to the first position in the page
 */
void resetColumnAdress() {
  writeCMDdisplay(0x10);
  writeCMDdisplay(0x00);
}

// -----------------------The End LCD--------------

///---------------------- GPS ------------------
SIGNAL(TIMER0_COMPA_vect) {
  char c = GPS.read();
  // if you want to debug, this is a good time to do it!
#ifdef UDR0
  if (GPSECHO)
    if (c) UDR0 = c;  
  // writing direct to UDR0 is much much faster than Serial.print 
  // but only one character can be written at a time. 
#endif
}

void useInterrupt(boolean v) {
  if (v) {
    // Timer0 is already used for millis() - we'll just interrupt somewhere
    // in the middle and call the "Compare A" function above
    OCR0A = 0xAF;
    TIMSK0 |= _BV(OCIE0A);
    usingInterrupt = true;
  } 
  else {
    // do not call the interrupt function COMPA anymore
    TIMSK0 &= ~_BV(OCIE0A);
    usingInterrupt = false;
  }
}


void btnInput()
{
  setMarker(2, true);
  state = !state;
}












































